<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tạo Post Mới - Album Ảnh Chuyên Nghiệp</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="public/css/albums.css">
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <header>
            <h1><i class="fas fa-plus-circle"></i> Tạo Post Mới</h1>
            <p class="subtitle">Thêm post mới vào album</p>
        </header>

        <div class="form-container">
            <form id="postForm" class="post-form">
                <input type="hidden" id="albumId" name="album_id" value="">

                <div class="form-group">
                    <label for="postTitle">
                        <i class="fas fa-heading"></i> Tiêu đề Post
                    </label>
                    <input type="text" id="postTitle" name="title" placeholder="Nhập tiêu đề post...">
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="cosplayer">
                            <i class="fas fa-user"></i> Cosplayer
                        </label>
                        <input type="text" id="cosplayer" name="cosplayer" placeholder="Tên cosplayer...">
                    </div>

                    <div class="form-group">
                        <label for="character">
                            <i class="fas fa-theater-masks"></i> Nhân vật
                        </label>
                        <input type="text" id="character" name="character" placeholder="Tên nhân vật...">
                    </div>
                </div>

                <div class="form-group">
                    <label for="source">
                        <i class="fas fa-film"></i> Nguồn
                    </label>
                    <input type="text" id="source" name="source" placeholder="Game/Anime/Manga...">
                </div>

                <div class="form-group">
                    <label for="postDescription">
                        <i class="fas fa-align-left"></i> Mô tả
                    </label>
                    <textarea id="postDescription" name="description" rows="3" placeholder="Mô tả về post..."></textarea>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-images"></i> Link Ảnh *
                    </label>
                    <div class="url-input-group">
                        <input type="url" id="imageUrlInput" class="url-input" placeholder="https://example.com/image.jpg">
                        <button type="button" class="btn btn-small" onclick="addImageUrl()">
                            <i class="fas fa-plus"></i> Thêm
                        </button>
                    </div>
                    <small class="form-help">Nhập từng link ảnh và nhấn Thêm. Có thể thêm nhiều ảnh.</small>
                    <div id="imagesList" class="items-list"></div>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-video"></i> Link Video
                    </label>
                    <div class="url-input-group">
                        <input type="url" id="videoUrlInput" class="url-input" placeholder="https://example.com/video.mp4">
                        <button type="button" class="btn btn-small" onclick="addVideoUrl()">
                            <i class="fas fa-plus"></i> Thêm
                        </button>
                    </div>
                    <small class="form-help">Nhập từng link video và nhấn Thêm. Có thể thêm nhiều video.</small>
                    <div id="videosList" class="items-list"></div>
                </div>

                <div class="form-group">
                    <label for="tags">
                        <i class="fas fa-tags"></i> Tags (phân cách bằng dấu phẩy)
                    </label>
                    <input type="text" id="tags" name="tags" placeholder="tag1, tag2, tag3...">
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Tạo Post
                    </button>
                    <a href="albums.php" class="btn btn-secondary" id="cancelBtn">
                        <i class="fas fa-times"></i> Hủy
                    </a>
                </div>
            </form>
        </div>
    </div>

    <script>
        const albumId = new URLSearchParams(window.location.search).get('album_id');
        if (albumId) {
            document.getElementById('albumId').value = albumId;
            document.getElementById('cancelBtn').href = 'album_detail.php?id=' + albumId;
        }
    </script>
    <script src="public/js/create_post.js"></script>
</body>
</html>
