<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tạo Album Mới - Album Ảnh Chuyên Nghiệp</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="public/css/albums.css">
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
                <a href="cosplay_scraper.php" class="taskbar-item">
                    <i class="fas fa-download"></i> <span>Scraper</span>
                </a>
                <a href="bulk_scraper.php" class="taskbar-item">
                    <i class="fas fa-spider"></i> <span>Bulk</span>
                </a>
                <a href="import_json.php" class="taskbar-item">
                    <i class="fas fa-file-import"></i> <span>Import</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <header>
            <h1><i class="fas fa-plus-circle"></i> Tạo Album Mới</h1>
            <p class="subtitle">Tạo album với tất cả ảnh ngay từ đầu</p>
        </header>

        <div class="form-container">
            <form id="albumForm" class="album-form">
                <div class="form-group">
                    <label for="albumTitle">
                        <i class="fas fa-heading"></i> Tên Album *
                    </label>
                    <input type="text" id="albumTitle" name="title" required placeholder="Nhập tên album...">
                </div>

                <div class="form-group">
                    <label for="albumThumbnail">
                        <i class="fas fa-image"></i> Ảnh Nền (Background) *
                    </label>
                    <input type="url" id="albumThumbnail" name="thumbnail" required placeholder="https://example.com/background.jpg">
                    <div class="preview-box" id="thumbnailPreview"></div>
                    <small class="form-help">Link URL của ảnh nền/ảnh bìa album</small>
                </div>

                <div class="form-group">
                    <label for="albumCategory">
                        <i class="fas fa-tags"></i> Danh mục (tùy chọn)
                    </label>
                    <select id="albumCategory" name="category">
                        <option value="">-- Chọn danh mục --</option>
                        <option value="Cosplay">Cosplay</option>
                        <option value="Game">Game</option>
                        <option value="Anime">Anime</option>
                        <option value="Art">Art</option>
                        <option value="Photo">Photo</option>
                        <option value="Other">Other</option>
                    </select>
                </div>

                <!-- Tabs for input methods -->
                <div class="upload-tabs" style="margin-top: 30px;">
                    <button type="button" class="tab-btn active" data-tab="links">
                        <i class="fas fa-link"></i> Nhập Link Ảnh
                    </button>
                    <button type="button" class="tab-btn" data-tab="json">
                        <i class="fas fa-code"></i> Nhập JSON
                    </button>
                </div>

                <!-- Tab: Links Input -->
                <div class="upload-tab-content active" id="linksTab">
                    <div class="form-group">
                        <label>
                            <i class="fas fa-images"></i> Link Ảnh *
                        </label>
                        <div class="url-input-group">
                            <input type="url" id="imageUrlInput" class="url-input" placeholder="https://example.com/image.jpg">
                            <button type="button" class="btn btn-small" onclick="addImageUrl()">
                                <i class="fas fa-plus"></i> Thêm
                            </button>
                        </div>
                        <small class="form-help">Nhập từng link ảnh và nhấn Thêm. Phải có ít nhất 1 ảnh.</small>
                        <div id="imagesList" class="items-list" style="margin-top: 15px;"></div>
                    </div>

                    <div class="form-group">
                        <label>
                            <i class="fas fa-video"></i> Link Video (tùy chọn)
                        </label>
                        <div class="url-input-group">
                            <input type="url" id="videoUrlInput" class="url-input" placeholder="https://example.com/video.mp4">
                            <button type="button" class="btn btn-small" onclick="addVideoUrl()">
                                <i class="fas fa-plus"></i> Thêm
                            </button>
                        </div>
                        <small class="form-help">Nhập từng link video và nhấn Thêm.</small>
                        <div id="videosList" class="items-list" style="margin-top: 15px;"></div>
                    </div>

                    <!-- Optional fields -->
                    <div class="form-row">
                        <div class="form-group">
                            <label for="cosplayer">
                                <i class="fas fa-user"></i> Cosplayer (tùy chọn)
                            </label>
                            <input type="text" id="cosplayer" name="cosplayer" placeholder="Tên cosplayer...">
                        </div>

                        <div class="form-group">
                            <label for="character">
                                <i class="fas fa-theater-masks"></i> Nhân vật (tùy chọn)
                            </label>
                            <input type="text" id="character" name="character" placeholder="Tên nhân vật...">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="source">
                            <i class="fas fa-film"></i> Nguồn (tùy chọn)
                        </label>
                        <input type="text" id="source" name="source" placeholder="Game/Anime/Manga...">
                    </div>

                    <div class="form-group">
                        <label for="tags">
                            <i class="fas fa-tags"></i> Tags (phân cách bằng dấu phẩy, tùy chọn)
                        </label>
                        <input type="text" id="tags" name="tags" placeholder="tag1, tag2, tag3...">
                    </div>
                </div>

                <!-- Tab: JSON Input -->
                <div class="upload-tab-content" id="jsonTab">
                    <div class="form-group">
                        <label>
                            <i class="fas fa-code"></i> JSON Data *
                        </label>
                        <textarea id="jsonInput" class="json-input-area" rows="15" placeholder='Paste JSON data here...&#10;Hệ thống sẽ tự động lấy:&#10;- images (hoặc videos)&#10;- cosplayer, character, source&#10;- tags, categories&#10;- photo_count, video_count'></textarea>
                        <small class="form-help">Paste JSON từ scraper hoặc file JSON. Hệ thống chỉ lấy những thông tin cần thiết.</small>
                        <div style="margin-top: 10px;">
                            <button type="button" class="btn btn-small" onclick="loadJsonFromScraped()">
                                <i class="fas fa-folder-open"></i> Load từ Scraped
                            </button>
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Tạo Album
                    </button>
                    <a href="albums.php" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Hủy
                    </a>
                </div>
            </form>
        </div>
    </div>

    <script src="public/js/create_album.js"></script>
    <script>
        // State
        let images = [];
        let videos = [];
        let jsonData = null;

        // Tab switching
        document.querySelectorAll('.tab-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                const tab = btn.dataset.tab;
                
                document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
                btn.classList.add('active');
                
                document.querySelectorAll('.upload-tab-content').forEach(c => c.classList.remove('active'));
                document.getElementById(tab + 'Tab').classList.add('active');
            });
        });

        // Add image URL
        function addImageUrl() {
            const url = document.getElementById('imageUrlInput').value.trim();
            
            if (!url) {
                alert('Vui lòng nhập link ảnh!');
                return;
            }
            
            try {
                new URL(url);
            } catch (e) {
                alert('URL không hợp lệ!');
                return;
            }
            
            if (images.includes(url)) {
                alert('Link ảnh này đã được thêm!');
                return;
            }
            
            images.push(url);
            document.getElementById('imageUrlInput').value = '';
            renderImagesList();
        }

        // Remove image
        function removeImage(index) {
            images.splice(index, 1);
            renderImagesList();
        }

        // Render images list
        function renderImagesList() {
            const list = document.getElementById('imagesList');
            if (images.length === 0) {
                list.innerHTML = '<p class="empty-list">Chưa có ảnh nào</p>';
                return;
            }
            
            list.innerHTML = images.map((url, index) => {
                return `
                <div class="item-card">
                    <img src="${url}" alt="Image ${index + 1}" onerror="this.src='https://via.placeholder.com/150?text=Error'">
                    <div class="item-info">
                        <p class="item-url">${url.substring(0, 50)}${url.length > 50 ? '...' : ''}</p>
                        <button type="button" class="btn-remove" onclick="removeImage(${index})">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                `;
            }).join('');
        }

        // Add video URL
        function addVideoUrl() {
            const url = document.getElementById('videoUrlInput').value.trim();
            
            if (!url) {
                alert('Vui lòng nhập link video!');
                return;
            }
            
            try {
                new URL(url);
            } catch (e) {
                alert('URL không hợp lệ!');
                return;
            }
            
            if (videos.includes(url)) {
                alert('Link video này đã được thêm!');
                return;
            }
            
            videos.push(url);
            document.getElementById('videoUrlInput').value = '';
            renderVideosList();
        }

        // Remove video
        function removeVideo(index) {
            videos.splice(index, 1);
            renderVideosList();
        }

        // Render videos list
        function renderVideosList() {
            const list = document.getElementById('videosList');
            if (videos.length === 0) {
                list.innerHTML = '<p class="empty-list">Chưa có video nào</p>';
                return;
            }
            
            list.innerHTML = videos.map((url, index) => {
                return `
                <div class="item-card">
                    <div class="item-preview">
                        <i class="fas fa-video"></i>
                    </div>
                    <div class="item-info">
                        <p class="item-url">${url.substring(0, 50)}${url.length > 50 ? '...' : ''}</p>
                        <button type="button" class="btn-remove" onclick="removeVideo(${index})">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                `;
            }).join('');
        }

        // Load JSON from scraped
        async function loadJsonFromScraped() {
            try {
                const response = await fetch('bulk_scraper_api.php?action=get_scraped_posts');
                const posts = await response.json();
                
                if (posts.length === 0) {
                    alert('Chưa có posts đã scrape!');
                    return;
                }
                
                // Show dialog to select post
                const postList = posts.map((post, index) => 
                    `${index + 1}. ${post.title || (post.cosplayer + ' - ' + post.character)}`
                ).join('\n');
                
                const postIndex = prompt(`Chọn post (1-${posts.length}):\n\n${postList}`);
                if (!postIndex) return;
                
                const selectedIndex = parseInt(postIndex) - 1;
                if (selectedIndex < 0 || selectedIndex >= posts.length) {
                    alert('Số không hợp lệ!');
                    return;
                }
                
                const selectedPost = posts[selectedIndex];
                document.getElementById('jsonInput').value = JSON.stringify(selectedPost, null, 2);
                
            } catch (error) {
                console.error('Load JSON error:', error);
                alert('Lỗi khi load JSON từ scraped posts');
            }
        }

        // Initialize
        document.addEventListener('DOMContentLoaded', () => {
            renderImagesList();
            renderVideosList();
            
            // Preview thumbnail
            document.getElementById('albumThumbnail').addEventListener('input', () => {
                const url = document.getElementById('albumThumbnail').value.trim();
                const preview = document.getElementById('thumbnailPreview');
                
                if (url) {
                    try {
                        new URL(url);
                        preview.innerHTML = `<img src="${url}" alt="Thumbnail preview" onerror="this.parentElement.innerHTML=''; this.parentElement.classList.remove('has-image');">`;
                        preview.classList.add('has-image');
                    } catch (e) {
                        preview.innerHTML = '';
                        preview.classList.remove('has-image');
                    }
                } else {
                    preview.innerHTML = '';
                    preview.classList.remove('has-image');
                }
            });

            // Form submit
            document.getElementById('albumForm').addEventListener('submit', async (e) => {
                e.preventDefault();
                
                const title = document.getElementById('albumTitle').value.trim();
                const thumbnail = document.getElementById('albumThumbnail').value.trim();
                const category = document.getElementById('albumCategory').value.trim();
                
                if (!title || !thumbnail) {
                    alert('Vui lòng điền đầy đủ Tên Album và Ảnh Nền!');
                    return;
                }
                
                let finalImages = [...images];
                let finalVideos = [...videos];
                let cosplayer = document.getElementById('cosplayer').value.trim();
                let character = document.getElementById('character').value.trim();
                let source = document.getElementById('source').value.trim();
                let tagsInput = document.getElementById('tags').value.trim();
                let tags = tagsInput ? tagsInput.split(',').map(t => t.trim()).filter(t => t) : [];
                
                // Check if using JSON tab
                const jsonTab = document.getElementById('jsonTab').classList.contains('active');
                if (jsonTab) {
                    const jsonText = document.getElementById('jsonInput').value.trim();
                    if (!jsonText) {
                        alert('Vui lòng nhập JSON data!');
                        return;
                    }
                    
                    try {
                        const json = JSON.parse(jsonText);
                        
                        // Extract only necessary fields
                        if (json.images && Array.isArray(json.images) && json.images.length > 0) {
                            finalImages = json.images;
                        }
                        if (json.videos && Array.isArray(json.videos) && json.videos.length > 0) {
                            finalVideos = json.videos;
                        }
                        
                        // Only use if not already set
                        if (!cosplayer && json.cosplayer) cosplayer = json.cosplayer;
                        if (!character && json.character) character = json.character;
                        if (!source && json.source) source = json.source;
                        if (tags.length === 0 && json.tags && Array.isArray(json.tags)) {
                            tags = json.tags;
                        }
                        
                    } catch (error) {
                        alert('JSON không hợp lệ!\n' + error.message);
                        return;
                    }
                }
                
                // Validate có ít nhất 1 ảnh hoặc 1 video
                if (finalImages.length === 0 && finalVideos.length === 0) {
                    alert('Phải có ít nhất 1 ảnh hoặc 1 video!');
                    return;
                }
                
                // Prepare data
                const formData = {
                    title: title,
                    thumbnail: thumbnail,
                    category: category,
                    images: finalImages,
                    videos: finalVideos,
                    cosplayer: cosplayer,
                    character: character,
                    source: source,
                    tags: tags,
                    photo_count: finalImages.length,
                    video_count: finalVideos.length
                };
                
                try {
                    const submitBtn = e.target.querySelector('button[type="submit"]');
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Đang tạo...';
                    
                    const response = await fetch('albums_api.php?action=create_album_with_post', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(formData)
                    });
                    
                    const result = await response.json();
                    
                    if (result.success) {
                        alert('Tạo album thành công!');
                        window.location.href = `album_detail.php?id=${result.album.id}`;
                    } else {
                        alert('Lỗi: ' + (result.error || 'Không thể tạo album'));
                    }
                } catch (error) {
                    console.error('Create album error:', error);
                    alert('Lỗi khi tạo album: ' + error.message);
                } finally {
                    const submitBtn = e.target.querySelector('button[type="submit"]');
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = '<i class="fas fa-save"></i> Tạo Album';
                }
            });
        });

        // Make functions global
        window.addImageUrl = addImageUrl;
        window.removeImage = removeImage;
        window.addVideoUrl = addVideoUrl;
        window.removeVideo = removeVideo;
        window.loadJsonFromScraped = loadJsonFromScraped;
    </script>
    <style>
        .json-input-area {
            width: 100%;
            min-height: 300px;
            font-family: 'Courier New', monospace;
            font-size: 0.9em;
            padding: 15px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            resize: vertical;
        }
        .json-input-area:focus {
            outline: none;
            border-color: #FF9AA2;
            box-shadow: 0 0 0 3px rgba(255, 154, 162, 0.2);
        }
    </style>
</body>
</html>