<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bulk Scraper - Cosplaytele.com</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="public/css/albums.css">
    <style>
        .scraper-dashboard {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: rgba(255, 255, 255, 0.95);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
            text-align: center;
        }
        .stat-card h3 {
            font-size: 2em;
            color: #FF9AA2;
            margin: 0;
        }
        .stat-card p {
            color: #666;
            margin: 5px 0 0 0;
        }
        .control-panel {
            background: rgba(255, 255, 255, 0.95);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px;
        }
        .progress-section {
            background: rgba(255, 255, 255, 0.95);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            display: none;
        }
        .progress-section.active {
            display: block;
        }
        .progress-bar-large {
            width: 100%;
            height: 30px;
            background: #e9ecef;
            border-radius: 15px;
            overflow: hidden;
            margin: 20px 0;
        }
        .progress-fill-large {
            height: 100%;
            background: linear-gradient(90deg, #FF9AA2, #FFB3BA);
            transition: width 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }
        .log-box {
            background: #1e1e1e;
            color: #00ff00;
            padding: 20px;
            border-radius: 10px;
            font-family: 'Courier New', monospace;
            font-size: 0.9em;
            max-height: 400px;
            overflow-y: auto;
            margin-top: 20px;
        }
        .log-entry {
            margin: 5px 0;
            padding: 5px;
        }
        .log-entry.error {
            color: #ff4444;
        }
        .log-entry.success {
            color: #44ff44;
        }
        .log-entry.info {
            color: #44aaff;
        }
        .posts-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }
        .post-preview-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        }
        .post-preview-card img {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }
        .post-preview-info {
            padding: 15px;
        }
        .post-preview-info h4 {
            margin: 0 0 10px 0;
            font-size: 0.95em;
            color: #333;
        }
        .post-preview-meta {
            font-size: 0.85em;
            color: #666;
        }
    </style>
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="cosplay_scraper.php" class="taskbar-item">
                    <i class="fas fa-download"></i> <span>Scraper</span>
                </a>
                <a href="bulk_scraper.php" class="taskbar-item active">
                    <i class="fas fa-spider"></i> <span>Bulk Scraper</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <header>
            <h1><i class="fas fa-spider"></i> Bulk Scraper - Cosplaytele.com</h1>
            <p class="subtitle">Crawl và scrape toàn bộ nội dung từ cosplaytele.com</p>
        </header>

        <div class="scraper-dashboard">
            <!-- Stats -->
            <div class="stats-grid">
                <div class="stat-card">
                    <h3 id="totalPosts">0</h3>
                    <p>Total Posts</p>
                </div>
                <div class="stat-card">
                    <h3 id="scrapedPosts">0</h3>
                    <p>Đã Scrape</p>
                </div>
                <div class="stat-card">
                    <h3 id="failedPosts">0</h3>
                    <p>Lỗi</p>
                </div>
                <div class="stat-card">
                    <h3 id="progressPercent">0%</h3>
                    <p>Tiến độ</p>
                </div>
            </div>

            <!-- Control Panel -->
            <div class="control-panel">
                <h2><i class="fas fa-cog"></i> Điều khiển</h2>
                
                <div class="form-group">
                    <label>
                        <i class="fas fa-folder"></i> Chọn Album để Import
                    </label>
                    <select id="albumSelect" class="form-control">
                        <option value="">-- Tạo album mới --</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-list"></i> Số trang muốn scrape (1-453)
                    </label>
                    <input type="number" id="maxPages" class="form-control" value="10" min="1" max="453">
                    <small class="form-help">Mặc định: 10 trang (khoảng 100-200 posts)</small>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-pause"></i> Delay giữa các request (giây)
                    </label>
                    <input type="number" id="delay" class="form-control" value="2" min="1" max="10">
                    <small class="form-help">Tránh bị block, khuyến nghị: 2-3 giây</small>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-filter"></i> Lọc theo Category (tùy chọn)
                    </label>
                    <select id="categoryFilter" class="form-control" multiple>
                        <option value="Cosplay Game">Cosplay Game</option>
                        <option value="Cosplay Nude">Cosplay Nude</option>
                        <option value="Cosplay Ero">Cosplay Ero</option>
                        <option value="Cosplay">Cosplay</option>
                        <option value="Video Cosplay">Video Cosplay</option>
                        <option value="Anime/Manga">Anime/Manga</option>
                        <option value="Free Style">Free Style</option>
                    </select>
                    <small class="form-help">Giữ Ctrl để chọn nhiều. Để trống = lấy tất cả</small>
                </div>

                <div class="form-actions">
                    <button id="startScrapeBtn" class="btn btn-primary">
                        <i class="fas fa-play"></i> Bắt đầu Scrape
                    </button>
                    <button id="stopScrapeBtn" class="btn btn-secondary" disabled>
                        <i class="fas fa-stop"></i> Dừng
                    </button>
                    <button id="viewScrapedBtn" class="btn btn-secondary">
                        <i class="fas fa-eye"></i> Xem đã Scrape
                    </button>
                </div>
            </div>

            <!-- Progress Section -->
            <div id="progressSection" class="progress-section">
                <h2><i class="fas fa-tasks"></i> Tiến độ</h2>
                <div class="progress-bar-large">
                    <div id="progressFill" class="progress-fill-large" style="width: 0%">0%</div>
                </div>
                <div id="currentStatus" style="text-align: center; color: #666; margin: 10px 0;">
                    Đang chuẩn bị...
                </div>
                <div class="log-box" id="logBox"></div>
            </div>

            <!-- Scraped Posts Preview -->
            <div id="postsPreview" style="display: none;">
                <h2><i class="fas fa-list"></i> Posts đã Scrape</h2>
                <div class="posts-grid" id="postsGrid"></div>
            </div>
        </div>
    </div>

    <script src="public/js/bulk_scraper.js"></script>
</body>
</html>
