<?php
header('Content-Type: application/json');

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'list':
        listImages();
        break;
    case 'delete':
        deleteImage();
        break;
    default:
        http_response_code(400);
        echo json_encode(['error' => 'Invalid action']);
        break;
}

/**
 * Lấy danh sách ảnh
 */
function listImages() {
    $uploadDir = __DIR__ . '/uploads/';
    
    if (!is_dir($uploadDir)) {
        echo json_encode([]);
        return;
    }
    
    $files = scandir($uploadDir);
    $images = [];
    
    foreach ($files as $file) {
        // Chỉ lấy file JSON
        if ($file === '.' || $file === '..' || pathinfo($file, PATHINFO_EXTENSION) !== 'json') {
            continue;
        }
        
        $filepath = $uploadDir . $file;
        $data = json_decode(file_get_contents($filepath), true);
        
        if ($data && isset($data['id'])) {
            $images[] = [
                'id' => $data['id'],
                'filename' => $data['url1'] ?? 'Image', // Dùng URL làm filename
                'url' => $data['url1'] ?? '',
                'negativeUrl' => $data['url2'] ?? '',
                'uploadDate' => $data['uploadDate'] ?? date('c', filemtime($filepath))
            ];
        }
    }
    
    // Sắp xếp theo thời gian upload (mới nhất trước)
    usort($images, function($a, $b) {
        return strtotime($b['uploadDate']) - strtotime($a['uploadDate']);
    });
    
    echo json_encode($images);
}

/**
 * Xóa ảnh
 */
function deleteImage() {
    if ($_SERVER['REQUEST_METHOD'] !== 'DELETE' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        return;
    }
    
    $imageId = $_GET['id'] ?? $_POST['id'] ?? '';
    
    if (empty($imageId)) {
        http_response_code(400);
        echo json_encode(['error' => 'Thiếu ID ảnh']);
        return;
    }
    
    $uploadDir = __DIR__ . '/uploads/';
    $dataFile = $uploadDir . $imageId . '.json';
    
    if (!file_exists($dataFile)) {
        http_response_code(404);
        echo json_encode(['error' => 'Không tìm thấy ảnh']);
        return;
    }
    
    $data = json_decode(file_get_contents($dataFile), true);
    
    if (!$data) {
        http_response_code(500);
        echo json_encode(['error' => 'Lỗi khi đọc dữ liệu']);
        return;
    }
    
    // Nếu là R2, có thể xóa trên R2 (tùy chọn)
    // Ở đây chỉ xóa file JSON
    
    $deleted = false;
    
    // Xóa file JSON
    if (file_exists($dataFile)) {
        $deleted = unlink($dataFile);
    }
    
    if ($deleted) {
        echo json_encode(['success' => true, 'message' => 'Xóa ảnh thành công']);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Không thể xóa file']);
    }
}
?>
