<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Albums - Album Ảnh Chuyên Nghiệp</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="public/css/albums.css">
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item active">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <header>
            <h1><i class="fas fa-folder-open"></i> Albums</h1>
            <p class="subtitle">Khám phá bộ sưu tập của chúng tôi</p>
        </header>

        <div class="albums-controls">
            <div class="search-box">
                <i class="fas fa-search"></i>
                <input type="text" id="searchInput" placeholder="Tìm kiếm album...">
            </div>
            <div class="filter-box">
                <select id="categoryFilter">
                    <option value="">Tất cả danh mục</option>
                    <option value="Cosplay">Cosplay</option>
                    <option value="Game">Game</option>
                    <option value="Anime">Anime</option>
                    <option value="Art">Art</option>
                </select>
            </div>
            <a href="create_album.php" class="btn btn-primary">
                <i class="fas fa-plus"></i> Tạo Album Mới
            </a>
        </div>

        <div class="albums-container">
            <div class="albums-grid" id="albumsGrid">
                <div class="loading" id="loading">
                    <i class="fas fa-spinner fa-spin"></i> Đang tải albums...
                </div>
            </div>
        </div>
    </div>

    <script src="public/js/albums.js"></script>
</body>
</html>
