# Hướng dẫn sử dụng tính năng Albums

Tính năng Albums cho phép bạn tạo các album riêng biệt (giống cosplaytele.com) và đăng các post chứa nhiều ảnh/video qua link.

## Cấu trúc tính năng

### 1. Albums Page (`albums.php`)
- Hiển thị danh sách tất cả albums
- Tìm kiếm albums theo tên hoặc mô tả
- Lọc albums theo danh mục
- Click vào album để xem chi tiết

### 2. Album Detail Page (`album_detail.php`)
- Hiển thị thông tin album (tiêu đề, mô tả, ảnh bìa)
- Hiển thị danh sách tất cả posts trong album
- Click vào post để xem chi tiết với modal

### 3. Create Album Page (`create_album.php`)
- Tạo album mới với:
  - Tiêu đề (bắt buộc)
  - Mô tả
  - Link ảnh bìa
  - Danh mục (Cosplay, Game, Anime, Art, Photo, Other)

### 4. Create Post Page (`create_post.php`)
- Tạo post mới trong album với:
  - Tiêu đề post
  - Cosplayer
  - Nhân vật
  - Nguồn (Game/Anime/Manga)
  - Mô tả
  - **Nhiều link ảnh** (bắt buộc có ít nhất 1 ảnh hoặc 1 video)
  - **Nhiều link video** (Youtube hoặc direct video link)
  - Tags (phân cách bằng dấu phẩy)

## Cách sử dụng

### Bước 1: Tạo Album
1. Vào trang **Albums** từ menu navigation
2. Click nút **"Tạo Album Mới"**
3. Điền thông tin:
   - Tiêu đề album (bắt buộc)
   - Mô tả (tùy chọn)
   - Link ảnh bìa (tùy chọn)
   - Danh mục (tùy chọn)
4. Click **"Tạo Album"**

### Bước 2: Tạo Post trong Album
1. Vào album vừa tạo (click vào album trong danh sách)
2. Click nút **"Tạo Post Mới"**
3. Điền thông tin:
   - **Link ảnh**: Nhập từng link ảnh và nhấn "Thêm" (có thể thêm nhiều ảnh)
   - **Link video**: Nhập từng link video và nhấn "Thêm" (hỗ trợ Youtube và direct video links)
   - Tiêu đề, Cosplayer, Nhân vật, Nguồn, Mô tả (tùy chọn)
   - Tags (phân cách bằng dấu phẩy)
4. Click **"Tạo Post"**

### Bước 3: Xem Albums và Posts
1. Vào trang **Albums** để xem tất cả albums
2. Sử dụng thanh tìm kiếm để tìm album
3. Lọc theo danh mục nếu cần
4. Click vào album để xem các posts
5. Click vào post để xem chi tiết với modal hiển thị tất cả ảnh/video

## Cấu trúc dữ liệu

### Albums
Dữ liệu được lưu trong thư mục `albums/` với cấu trúc:
```
albums/
├── {album_id}.json          # Thông tin album
└── {album_id}/
    └── posts/
        ├── {post_id}.json   # Thông tin post
        └── ...
```

### Album JSON Format
```json
{
  "id": "timestamp-uniqueid",
  "title": "Tên Album",
  "description": "Mô tả album",
  "thumbnail": "https://example.com/thumbnail.jpg",
  "category": "Cosplay",
  "createdDate": "2025-01-01T00:00:00+00:00",
  "updatedDate": "2025-01-01T00:00:00+00:00"
}
```

### Post JSON Format
```json
{
  "id": "timestamp-uniqueid",
  "album_id": "album-id",
  "title": "Tiêu đề post",
  "description": "Mô tả post",
  "images": [
    "https://example.com/image1.jpg",
    "https://example.com/image2.jpg"
  ],
  "videos": [
    "https://youtube.com/watch?v=...",
    "https://example.com/video.mp4"
  ],
  "cosplayer": "Tên Cosplayer",
  "character": "Tên nhân vật",
  "source": "Tên game/anime/manga",
  "tags": ["tag1", "tag2"],
  "thumbnail": "https://example.com/first-image.jpg",
  "createdDate": "2025-01-01T00:00:00+00:00",
  "updatedDate": "2025-01-01T00:00:00+00:00"
}
```

## API Endpoints

Tất cả API endpoints nằm trong `albums_api.php`:

### Albums
- `GET albums_api.php?action=list_albums` - Lấy danh sách albums
- `GET albums_api.php?action=get_album&id={album_id}` - Lấy thông tin album
- `POST albums_api.php?action=create_album` - Tạo album mới
- `POST albums_api.php?action=update_album&id={album_id}` - Cập nhật album
- `POST albums_api.php?action=delete_album&id={album_id}` - Xóa album

### Posts
- `GET albums_api.php?action=list_posts&album_id={album_id}` - Lấy danh sách posts
- `GET albums_api.php?action=get_post&album_id={album_id}&post_id={post_id}` - Lấy thông tin post
- `POST albums_api.php?action=create_post` - Tạo post mới
- `POST albums_api.php?action=update_post&album_id={album_id}&post_id={post_id}` - Cập nhật post
- `POST albums_api.php?action=delete_post&album_id={album_id}&post_id={post_id}` - Xóa post

## Tính năng nổi bật

✅ **Tổ chức theo albums**: Mỗi album là một bộ sưu tập riêng biệt
✅ **Nhiều ảnh/video**: Mỗi post có thể chứa nhiều ảnh và video
✅ **Hỗ trợ Youtube**: Tự động embed video Youtube
✅ **Tìm kiếm và lọc**: Tìm kiếm albums và lọc theo danh mục
✅ **Modal xem post**: Xem chi tiết post với modal đẹp mắt
✅ **Responsive**: Giao diện responsive trên mọi thiết bị
✅ **Thông tin chi tiết**: Hỗ trợ Cosplayer, Nhân vật, Nguồn, Tags

## Lưu ý

- Post phải có ít nhất 1 ảnh hoặc 1 video
- Thumbnail của post tự động lấy ảnh đầu tiên nếu có
- Thumbnail của album có thể được set khi tạo album
- Tất cả dữ liệu được lưu dưới dạng JSON files
- Thư mục `albums/` sẽ được tạo tự động khi tạo album đầu tiên

## Yêu cầu

- PHP 7.4+
- Web server với quyền ghi file
- Đã cấu hình `.htaccess` đúng (đã có sẵn trong project)

## Troubleshooting

**Lỗi không tạo được album:**
- Kiểm tra quyền ghi của thư mục `albums/`
- Chạy: `chmod 755 albums` (Linux/Mac)

**Lỗi không hiển thị ảnh:**
- Kiểm tra link ảnh có hợp lệ không
- Kiểm tra CORS nếu ảnh từ domain khác

**Lỗi không embed được Youtube:**
- Kiểm tra link Youtube có đúng định dạng không
- Link phải có dạng: `https://youtube.com/watch?v=...` hoặc `https://youtu.be/...`
