<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Ảnh - Album Chuyên Nghiệp</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .upload-page-container {
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
        }
        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            background: rgba(255,255,255,0.2);
            border-radius: 8px;
            transition: all 0.3s ease;
        }
        .back-link:hover {
            background: rgba(255,255,255,0.3);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="upload-page-container">
            <a href="index.php" class="back-link">
                <i class="fas fa-arrow-left"></i> Quay lại Gallery
            </a>
            
            <header>
                <h1><i class="fas fa-cloud-upload-alt"></i> Upload Ảnh</h1>
                <p class="subtitle">Thêm ảnh mới vào album</p>
            </header>

            <div class="upload-section">
                <div class="upload-tabs">
                    <button class="tab-btn active" data-tab="file">
                        <i class="fas fa-file-upload"></i> Upload File
                    </button>
                <button class="tab-btn" data-tab="url">
                    <i class="fas fa-link"></i> Upload bằng Link
                </button>
            </div>
                </button>

                <!-- Tab Upload File -->
                <div class="upload-tab-content active" id="fileTab">
                    <div class="upload-form">
                        <div class="upload-group">
                            <label class="upload-label">
                                <i class="fas fa-image"></i> Ảnh đầu (Ảnh gốc)
                            </label>
                            <div class="upload-box" id="uploadBox1">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <p>Kéo thả ảnh vào đây hoặc click để chọn</p>
                                <input type="file" id="fileInput1" accept="image/*">
                            </div>
                            <div class="preview-box" id="preview1"></div>
                        </div>
                        
                        <div class="upload-group">
                            <label class="upload-label">
                                <i class="fas fa-eye"></i> Ảnh khi bấm mắt
                            </label>
                            <div class="upload-box" id="uploadBox2">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <p>Kéo thả ảnh vào đây hoặc click để chọn</p>
                                <input type="file" id="fileInput2" accept="image/*">
                            </div>
                            <div class="preview-box" id="preview2"></div>
                        </div>
                        
                        <button class="btn btn-primary" id="uploadBtn" disabled>
                            <i class="fas fa-upload"></i> Upload Ảnh lên Cloudflare R2
                        </button>
                    </div>
                </div>

                <!-- Tab Upload URL -->
                <div class="upload-tab-content" id="urlTab">
                    <div class="upload-form">
                        <div class="upload-group">
                            <label class="upload-label">
                                <i class="fas fa-image"></i> Link ảnh đầu (Ảnh gốc)
                            </label>
                            <input type="url" id="urlInput1" class="url-input" placeholder="https://example.com/image1.jpg">
                            <div class="preview-box" id="previewUrl1"></div>
                        </div>
                        
                        <div class="upload-group">
                            <label class="upload-label">
                                <i class="fas fa-eye"></i> Link ảnh khi bấm mắt
                            </label>
                            <input type="url" id="urlInput2" class="url-input" placeholder="https://example.com/image2.jpg">
                            <div class="preview-box" id="previewUrl2"></div>
                        </div>
                        
                        <button class="btn btn-primary" id="uploadUrlBtn">
                            <i class="fas fa-link"></i> Thêm Ảnh từ Link
                        </button>
                    </div>
                </div>

                <div class="upload-progress" id="uploadProgress" style="display: none;">
                    <div class="progress-bar">
                        <div class="progress-fill" id="progressFill"></div>
                    </div>
                    <span id="progressText">0%</span>
                </div>
            </div>
        </div>
    </div>

    <script src="public/js/upload.js"></script>
</body>
</html>

