<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tạo Album Mới - Album Ảnh Chuyên Nghiệp</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="public/css/albums.css">
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <header>
            <h1><i class="fas fa-plus-circle"></i> Tạo Album Mới</h1>
            <p class="subtitle">Tạo album mới để chia sẻ bộ sưu tập của bạn</p>
        </header>

        <div class="form-container">
            <form id="albumForm" class="album-form">
                <div class="form-group">
                    <label for="albumTitle">
                        <i class="fas fa-heading"></i> Tiêu đề Album *
                    </label>
                    <input type="text" id="albumTitle" name="title" required placeholder="Nhập tiêu đề album...">
                </div>

                <div class="form-group">
                    <label for="albumDescription">
                        <i class="fas fa-align-left"></i> Mô tả
                    </label>
                    <textarea id="albumDescription" name="description" rows="4" placeholder="Mô tả về album..."></textarea>
                </div>

                <div class="form-group">
                    <label for="albumThumbnail">
                        <i class="fas fa-image"></i> Link Ảnh Bìa
                    </label>
                    <input type="url" id="albumThumbnail" name="thumbnail" placeholder="https://example.com/thumbnail.jpg">
                    <div class="preview-box" id="thumbnailPreview"></div>
                    <small class="form-help">Link URL của ảnh bìa album</small>
                </div>

                <div class="form-group">
                    <label for="albumCategory">
                        <i class="fas fa-tags"></i> Danh mục
                    </label>
                    <select id="albumCategory" name="category">
                        <option value="">-- Chọn danh mục --</option>
                        <option value="Cosplay">Cosplay</option>
                        <option value="Game">Game</option>
                        <option value="Anime">Anime</option>
                        <option value="Art">Art</option>
                        <option value="Photo">Photo</option>
                        <option value="Other">Other</option>
                    </select>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Tạo Album
                    </button>
                    <a href="albums.php" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Hủy
                    </a>
                </div>
            </form>
        </div>
    </div>

    <script src="public/js/create_album.js"></script>
</body>
</html>
