# Hướng dẫn sử dụng Cosplay Scraper Tool

Tool này cho phép bạn lấy thông tin từ cosplaytele.com và import vào hệ thống albums.

## Tính năng

1. **Scrape từ URL**: Lấy thông tin từ URL cosplaytele.com
2. **Xuất JSON**: Tạo file JSON chuẩn để lưu trữ
3. **Import vào Album**: Import trực tiếp vào album đã chọn
4. **Import từ JSON**: Import từ file JSON có sẵn

## Cách sử dụng

### Option 1: Scrape trực tiếp từ URL

1. Vào trang **Scraper** từ menu
2. Nhập URL từ cosplaytele.com (ví dụ: `https://cosplaytele.com/fleurdelys/`)
3. Chọn album để import (nếu muốn import ngay)
4. Click **"Lấy Thông Tin"**
5. Xem preview thông tin đã lấy
6. Có thể:
   - **Copy JSON**: Copy JSON để lưu trữ
   - **Download JSON**: Tải file JSON về máy
   - **Import vào Album**: Import trực tiếp vào album đã chọn

### Option 2: Import từ JSON file

1. Vào trang **Import JSON** từ menu
2. Chọn album để import
3. Paste JSON data vào ô hoặc upload file JSON
4. Click **"Preview"** để xem trước
5. Click **"Import"** để import vào album

## Cấu trúc JSON chuẩn

```json
{
  "title": "水淼Aqua cosplay Fleurdelys – Wuthering Waves",
  "cosplayer": "水淼Aqua",
  "character": "Fleurdelys",
  "source": "Wuthering Waves",
  "photo_count": 75,
  "video_count": 0,
  "images": [
    "https://example.com/image1.jpg",
    "https://example.com/image2.jpg"
  ],
  "videos": [],
  "tags": ["Cartethyia", "Fleurdelys", "Wuthering Waves"],
  "categories": ["Cosplay Ero", "Cosplay Game"],
  "download_links": [
    {
      "type": "mediafire",
      "url": "https://mediafire.com/...",
      "text": "Download Mediafire"
    },
    {
      "type": "telegram",
      "url": "https://telegram.org/...",
      "text": "Download Telegram"
    }
  ],
  "source_url": "https://cosplaytele.com/fleurdelys/"
}
```

## Các trường dữ liệu

### Bắt buộc
- `images` hoặc `videos`: Phải có ít nhất 1 ảnh hoặc 1 video

### Tùy chọn
- `title`: Tiêu đề post
- `cosplayer`: Tên cosplayer
- `character`: Tên nhân vật
- `source`: Nguồn (Game/Anime/Manga)
- `photo_count`: Số lượng ảnh
- `video_count`: Số lượng video
- `tags`: Array các tags
- `categories`: Array các categories
- `download_links`: Array các link download
- `source_url`: URL gốc của bài viết
- `description`: Mô tả (không cần thiết)

## Cấu trúc Post sau khi import

Sau khi import, post sẽ có cấu trúc đầy đủ:

```json
{
  "id": "timestamp-uniqueid",
  "album_id": "album-id",
  "title": "...",
  "cosplayer": "...",
  "character": "...",
  "source": "...",
  "images": [...],
  "videos": [...],
  "tags": [...],
  "categories": [...],
  "download_links": [...],
  "photo_count": 75,
  "video_count": 0,
  "source_url": "...",
  "thumbnail": "first-image-url",
  "createdDate": "2025-01-01T00:00:00+00:00",
  "updatedDate": "2025-01-01T00:00:00+00:00"
}
```

## Lưu ý

- **Thông tin được lấy tự động** từ cosplaytele.com:
  - Cosplayer, Character, Source
  - Số lượng photos/videos
  - Tags và Categories
  - Download links (Mediafire, Telegram, Gofile, SoraFolder)
  - Link ảnh từ trang

- **Download links** sẽ được hiển thị trong modal khi xem post

- **Source URL** được lưu để tham chiếu lại bài gốc

- **Photo count và Video count** được dùng để hiển thị số lượng thay vì đếm từ array

- Tất cả dữ liệu được **lưu vào database (JSON files)** và giữ nguyên trên web

## Troubleshooting

**Lỗi không lấy được thông tin:**
- Kiểm tra URL có đúng định dạng cosplaytele.com không
- Kiểm tra kết nối internet
- Có thể trang web đã thay đổi cấu trúc HTML

**Lỗi không import được:**
- Kiểm tra JSON có đúng định dạng không
- Đảm bảo có ít nhất 1 ảnh hoặc 1 video
- Kiểm tra đã chọn album chưa

**Ảnh không hiển thị:**
- Kiểm tra link ảnh có hợp lệ không
- Kiểm tra CORS nếu ảnh từ domain khác
