# Hướng dẫn sử dụng Bulk Scraper

Bulk Scraper cho phép bạn crawl và scrape toàn bộ nội dung từ cosplaytele.com tự động.

## Tính năng

1. **Crawl toàn bộ website**: Lấy danh sách tất cả posts từ nhiều trang
2. **Scrape tự động**: Tự động scrape chi tiết từng post
3. **Lưu vào database**: Lưu vào thư mục `scraped/` dưới dạng JSON
4. **Import vào Album**: Import các posts đã scrape vào album
5. **Real-time progress**: Theo dõi tiến độ scraping real-time

## Cách sử dụng

### Bước 1: Vào trang Bulk Scraper
- Từ menu navigation, click **"Bulk Scraper"**

### Bước 2: Cấu hình
1. **Chọn Album**: Chọn album để import sau khi scrape (hoặc để trống để tạo mới sau)
2. **Số trang muốn scrape**: Nhập số trang muốn crawl (1-453)
   - Mỗi trang có khoảng 10-20 posts
   - Mặc định: 10 trang (~100-200 posts)
3. **Delay**: Thời gian chờ giữa các request (giây)
   - Khuyến nghị: 2-3 giây để tránh bị block
4. **Category Filter**: Lọc theo category (tùy chọn)
   - Có thể chọn nhiều categories
   - Để trống = lấy tất cả

### Bước 3: Bắt đầu Scraping
1. Click **"Bắt đầu Scrape"**
2. Hệ thống sẽ:
   - Lấy danh sách posts từ các trang
   - Scrape chi tiết từng post
   - Lưu vào thư mục `scraped/`
3. Theo dõi tiến độ trong phần Progress
4. Xem log chi tiết trong log box

### Bước 4: Xem và Import Posts
1. Click **"Xem đã Scrape"** để xem tất cả posts đã scrape
2. Click **"Import"** trên mỗi post để import vào album
3. Hoặc import nhiều posts cùng lúc

## Cấu trúc dữ liệu

### Posts được lưu trong `scraped/`
```
scraped/
├── post-slug-1.json
├── post-slug-2.json
└── ...
```

### Format JSON
```json
{
  "slug": "post-slug",
  "source_url": "https://cosplaytele.com/...",
  "title": "...",
  "cosplayer": "...",
  "character": "...",
  "source": "...",
  "photo_count": 75,
  "video_count": 0,
  "images": ["url1", "url2", ...],
  "videos": [],
  "tags": ["tag1", "tag2"],
  "categories": ["Cosplay Game", "Cosplay Ero"],
  "download_links": [...],
  "thumbnail": "first-image-url",
  "scraped_date": "2025-01-01T00:00:00+00:00"
}
```

## Quy trình hoạt động

### Phase 1: Crawl Posts List
1. Fetch trang đầu tiên (https://cosplaytele.com/)
2. Parse HTML để lấy danh sách posts
3. Lặp lại cho các trang tiếp theo (page/2, page/3, ...)
4. Thu thập tất cả post URLs

### Phase 2: Scrape Details
1. Với mỗi post URL:
   - Fetch HTML của post
   - Parse để lấy:
     - Cosplayer, Character, Source
     - Số lượng photos/videos
     - Tags và Categories
     - Download links
     - Image URLs
   - Lưu vào file JSON

### Phase 3: Import to Album
1. Chọn album
2. Import post đã scrape vào album
3. Post sẽ xuất hiện trong album như posts bình thường

## API Endpoints

- `GET bulk_scraper_api.php?action=get_posts_list&page={page}&max_pages={max}` - Lấy danh sách posts từ trang
- `POST bulk_scraper_api.php?action=scrape_post` - Scrape chi tiết một post
- `GET bulk_scraper_api.php?action=get_scraped_posts` - Lấy tất cả posts đã scrape
- `POST bulk_scraper_api.php?action=delete_scraped&slug={slug}` - Xóa post đã scrape
- `POST bulk_scraper_api.php?action=import_to_album` - Import vào album
- `GET bulk_scraper_api.php?action=list_albums` - List albums

## Lưu ý quan trọng

### Rate Limiting
- **Luôn set delay**: Ít nhất 2 giây giữa các request
- **Tránh scrape quá nhiều**: Bắt đầu với 10-20 trang
- **Kiểm tra log**: Nếu thấy nhiều lỗi, tăng delay

### Performance
- Scraping có thể mất nhiều thời gian:
  - 100 posts với delay 2s = ~3-5 phút
  - 500 posts với delay 2s = ~15-20 phút
- Có thể dừng và tiếp tục sau

### Dữ liệu
- Posts được lưu trong `scraped/` directory
- Không tự động xóa khi import vào album
- Có thể import nhiều lần vào các album khác nhau

### Troubleshooting

**Lỗi "Không thể fetch URL":**
- Kiểm tra kết nối internet
- Tăng delay time
- Có thể website đang block requests

**Lỗi "Không tìm thấy posts":**
- Website có thể đã thay đổi cấu trúc HTML
- Cần update parser

**Scraping bị dừng giữa chừng:**
- Click "Dừng" nếu muốn dừng
- Posts đã scrape vẫn được lưu
- Có thể tiếp tục scrape các posts còn lại

**Import không thành công:**
- Kiểm tra đã chọn album chưa
- Kiểm tra post có ít nhất 1 ảnh/video không
- Xem log để biết lỗi cụ thể

## Tips

1. **Bắt đầu nhỏ**: Scrape 5-10 trang trước để test
2. **Kiểm tra chất lượng**: Xem một vài posts đã scrape trước khi import hàng loạt
3. **Backup**: Backup thư mục `scraped/` nếu cần
4. **Organize**: Tạo albums riêng cho từng category nếu muốn

## Bảo mật

- Scraper chỉ đọc public content từ cosplaytele.com
- Không spam requests
- Tuân thủ robots.txt (nếu có)
- Dùng cho mục đích cá nhân/backup
