# Album Ảnh Chuyên Nghiệp (PHP)

Ứng dụng web album ảnh với đầy đủ chức năng upload, quản lý và xem ảnh với tính năng negative thực sự.

## Tính năng

- ✅ Upload ảnh (kéo thả hoặc click để chọn)
- ✅ Tự động tạo ảnh negative khi upload (ảnh -1, -2, -3...)
- ✅ Click icon mắt để chuyển đổi giữa ảnh gốc và ảnh negative
- ✅ Xem ảnh fullscreen với modal
- ✅ Xóa ảnh (tự động xóa cả ảnh gốc và negative)
- ✅ Responsive design
- ✅ UI đẹp và hiện đại

## Yêu cầu hệ thống

- PHP 7.4 trở lên
- Extension GD Library (để xử lý ảnh)
- Web server (Apache/Nginx) hoặc PHP built-in server

## Cài đặt

1. Đảm bảo PHP đã cài đặt và có extension GD:
```bash
php -m | grep -i gd
```

2. Nếu chưa có GD, cài đặt:
   - **Windows**: Uncomment `extension=gd` trong php.ini
   - **Linux**: `sudo apt-get install php-gd` (Ubuntu/Debian) hoặc `sudo yum install php-gd` (CentOS)

3. Chạy server:

**Với PHP built-in server:**
```bash
php -S localhost:8000
```

**Với Apache/Nginx:**
- Copy project vào thư mục web server (htdocs, www, public_html...)
- Truy cập qua domain hoặc localhost

4. Mở trình duyệt và truy cập:
```
http://localhost:8000
```

## Cách sử dụng

1. **Upload ảnh**: Kéo thả ảnh vào vùng upload hoặc click để chọn file
   - Khi upload, hệ thống tự động tạo ảnh negative (ví dụ: `1.jpg` → `-1.jpg`)

2. **Xem negative**: Click vào icon mắt ở góc phải trên của ảnh
   - Lần 1: Chuyển sang ảnh negative (ảnh -1, -2, -3...)
   - Lần 2: Chuyển về ảnh gốc (ảnh 1, 2, 3...)

3. **Xem fullscreen**: Click vào ảnh để xem ở chế độ fullscreen
   - Dùng phím mũi tên hoặc nút để chuyển ảnh
   - Phím ESC để đóng

4. **Xóa ảnh**: Click vào icon thùng rác ở góc trái trên của ảnh (hiện khi hover)
   - Tự động xóa cả ảnh gốc và ảnh negative

## Cấu trúc project

```
AlbumUD/
├── index.php          # Trang chủ
├── upload.php         # Xử lý upload và tạo ảnh negative
├── api.php            # API lấy danh sách và xóa ảnh
├── .htaccess          # Cấu hình Apache
├── css/
│   └── style.css      # Styles
├── js/
│   └── app.js         # Frontend JavaScript
└── uploads/           # Thư mục lưu ảnh (tự động tạo)
    ├── 1.jpg          # Ảnh gốc
    ├── -1.jpg         # Ảnh negative
    ├── 2.jpg
    ├── -2.jpg
    └── ...
```

## Cách hoạt động

1. **Upload**: Khi upload ảnh, `upload.php` sẽ:
   - Lưu ảnh gốc với tên unique (ví dụ: `1234567890-abc123.jpg`)
   - Tạo ảnh negative bằng GD Library và lưu với tên `-1234567890-abc123.jpg`

2. **Toggle Negative**: Khi click icon mắt:
   - JavaScript thay đổi `src` của thẻ `<img>` từ URL ảnh gốc sang URL ảnh negative
   - Không dùng CSS filter, mà load ảnh negative thực sự đã được tạo sẵn

3. **Xóa**: Khi xóa ảnh, hệ thống tự động xóa cả ảnh gốc và ảnh negative

## Công nghệ sử dụng

- **Backend**: PHP 7.4+
- **Image Processing**: GD Library
- **Frontend**: Vanilla JavaScript, HTML5, CSS3
- **Icons**: Font Awesome

## Lưu ý

- Đảm bảo thư mục `uploads/` có quyền ghi (chmod 755 hoặc 777)
- File upload tối đa 10MB (có thể chỉnh trong `.htaccess`)
- Ảnh negative được tạo tự động khi upload, không cần xử lý lại
