# Hướng dẫn cài đặt Cloudinary SDK

## Bước 1: Cài đặt Composer (nếu chưa có)

### Windows:
1. Tải Composer từ: https://getcomposer.org/download/
2. Chạy file `Composer-Setup.exe`
3. Hoặc tải `composer.phar` và đặt vào thư mục project

### Linux/Mac:
```bash
curl -sS https://getcomposer.org/installer | php
```

## Bước 2: Cài đặt Cloudinary SDK

Trong thư mục project, chạy lệnh:

```bash
composer install
```

Hoặc nếu dùng `composer.phar`:

```bash
php composer.phar install
```

## Bước 3: Kiểm tra

Sau khi cài đặt, sẽ có thư mục `vendor/` trong project. File `vendor/autoload.php` sẽ được tự động load.

## Bước 4: Cấu hình Cloudinary

Mở file `config.php` và điền thông tin:

```php
define('CLOUDINARY_CLOUD_NAME', 'your-cloud-name');
define('CLOUDINARY_API_KEY', 'your-api-key');
define('CLOUDINARY_API_SECRET', 'your-api-secret');
```

## Lưu ý

- Nếu không thể cài Composer trên server, có thể cài local rồi upload thư mục `vendor/` lên server
- Đảm bảo thư mục `vendor/` có quyền đọc

